#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <sysutils.hpp> //Win32Check()

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;

HIDP_CAPS capabilities;

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

HANDLE  hidDeviceObject;

BYTE *inputReportBuffer; //bufor danych wejsciowych
//---------------------------------------------------------
bool readUSBReport(HANDLE, void*, USHORT intputReportByteLength)
{
   DWORD result = 0;
   DWORD numberOfBytesRead = 0;
   OVERLAPPED *overlapped = NULL;
   if(overlapped == NULL){
       overlapped = new OVERLAPPED;
       overlapped->hEvent = CreateEvent(NULL, TRUE, TRUE, "");
       overlapped->Offset = 0;
       overlapped->OffsetHigh = 0;
   }
   if(!ReadFile(hidDeviceObject, inputReportBuffer, intputReportByteLength,
                &numberOfBytesRead, overlapped)) {
      if(GetLastError() == ERROR_IO_PENDING) {
          result = WaitForSingleObject(overlapped->hEvent, 100);
	        if(result == WAIT_TIMEOUT) {
	            CancelIo(hidDeviceObject);
	            return false;
	        }
	        else
                    if(result == WAIT_FAILED){
	              displayError("Bd odczytu danych.");
	              return false;
	            }
	        GetOverlappedResult(hidDeviceObject, overlapped,
                             &numberOfBytesRead, FALSE);
      }
      else
         displayError("Bd odczytu danych.");
   }
   ResetEvent(overlapped->hEvent);
   if(numberOfBytesRead==capabilities.InputReportByteLength){
     for(USHORT i=0; i<capabilities.InputReportByteLength; i++)
        printf("%d ", inputReportBuffer[i]);
        printf("\n");
   }
   else {
     printf("Bledna liczba bajtow odebranych.\n",numberOfBytesRead);
   }
   releaseMemory(overlapped);
   return true;
}
//---------------------------------------------------------
int main()
{

  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

  long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);

  bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                      OUT PHIDP_PREPARSED_DATA *PreparsedData);

  bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);


  hHidLib = LoadLibrary("HID.DLL");
  if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

  (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
  (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
  (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
  (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");


   if (!HidD_GetHidGuid || !HidP_GetCaps || !HidD_GetPreparsedData
       || !HidD_FreePreparsedData){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
          cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
          hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ | GENERIC_WRITE,
                                     FILE_SHARE_READ | FILE_SHARE_WRITE,
                                     NULL,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,NULL);
          break;
       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);

   if(HidD_GetPreparsedData(hidDeviceObject, &preparsedData)){
      HidP_GetCaps(preparsedData, &capabilities);
      inputReportBuffer = new BYTE[capabilities.InputReportByteLength];
      while(true) { //cykliczny odczyt danych z wybranego urzdzenia

          readUSBReport(hidDeviceObject, inputReportBuffer,
                        capabilities.InputReportByteLength);

          if(inputReportBuffer[6]==64) {
             HidD_FreePreparsedData(preparsedData);
             Win32Check(CloseHandle(hidDeviceObject));
             break;
          }
      }
   }
   releaseMemory(inputReportBuffer);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

